/**
 * Created by Administrator on 2020/4/5 0005.
 */


var imgFolder = location.href.replace(/index\.html.*/, 'img/')

// 初始化圖像URL為絕對路徑
function setImgUrl() {
  $('.profile-picture-show').attr('src', imgFolder + 'placeholder-image_2x.png')
  $('.company-logo-show').attr('src', imgFolder + 'logo-placeholder_2x.png')
  $('.phone-icon').attr('src', imgFolder + 'phone-icon-2x.png')
  $('.email-icon').attr('src', imgFolder + 'email-icon-2x.png')
  $('.link-icon').attr('src', imgFolder + 'link-icon-2x.png')
  $('.address-icon').attr('src', imgFolder + 'address-icon-2x.png')
  $('.facebook-icon').attr('src', imgFolder + 'facebook-icon-2x.png')
  $('.twitter-icon').attr('src', imgFolder + 'twitter-icon-2x.png')
  $('.linkedin-icon').attr('src', imgFolder + 'linkedin-icon-2x.png')
  $('.instagram-icon').attr('src', imgFolder + 'instagram-icon-2x.png')
}

// 切換TAB，兼容ie8事件
function changeSelect(e) {
  var event = e || window.event;
  var target = event.target || event.srcElement;
  $('.template-conf').hide()
  $('.detail-conf').hide()
  $('.style-conf').hide()
  $('.image-conf').hide()
  $('.' + target.className + '-conf').show()
}

function changeTpl(num) {
  var tpl = $('.tpl')
  tpl.removeClass('signature_out_start')
  $('.signature-tpl' + num).addClass('signature_out_start')
}

// 初始化輸入域
function initInputEvent() {
  var detailInputs = $('.detail-input')
  var profilePictureInput = $('.profile-picture')
  var companyLogoInput = $('.company-logo')

  // 初始化細節區域輸入事件
  detailInputs.on('blur', function () {
    var resClass = this.className.split(' ')[1]
    var resDom = $('.' + resClass + '-res')

    if(resDom.hasClass('text-link')) {
      resDom.attr('href', $(this).val())
    }

    if(resClass === 'office-phone' || resClass === 'mobile-phone') {
      if ($('.office-phone').val() !== '' && $('.mobile-phone').val() !== '') {
        $('.col').html('&nbsp;&nbsp;|')
      } else {
        $('.col').text('')
      }
    }

    if(resDom.hasClass('email-link')) {
      resDom.attr('href', 'mailto:' + $(this).val())
    }

    if (resDom.hasClass('link')) {
      resDom.attr('href', $(this).val())
      if ($(this).val() === '') {
        resDom.css('display', 'none')
      } else {
        resDom.css('display', 'inline-block')
      }
    } else {
      resDom.text($(this).val())
    }
  })
  // 初始化主題色輸入事件
  var themeColorSelected = $(".theme-color-select span");
  var themeColorSelectLi = $(".theme-color-select li");

  themeColorSelected.click(function (e) {
    $(this).next("ul").show();
    e.stopPropagation();
  });

  themeColorSelectLi.click(function () {

    var color = $(this).css('background-color');

    themeColorSelected.css('background-color', color)

    var iconDoms = $('.icon')
    $(iconDoms).css('backgroundColor', color)

    var divideDoms = $('.divide')
    $(divideDoms).css('borderColor', color)
    $(this).parent('ul').hide();
  });

  // 初始化字體色輸入事件
  var textColorSelected = $(".text-color-select span");
  var textColorSelectLi = $(".text-color-select li");

  textColorSelected.click(function (e) {
    $(this).next("ul").show();
    e.stopPropagation();
  });

  textColorSelectLi.click(function () {

    var color = $(this).css('background-color');

    textColorSelected.css('background-color', color)

    var textDoms = $('.text')
    $(textDoms).css('color', color)
    $(this).parent('ul').hide();
  });

  // 切换字体样式
  var fontFamilySelected = $(".font-family-select span");
  var fontFamilySelectLi = $(".font-family-select li");

  fontFamilySelected.click(function (e) {
    $(this).next("ul").show();
    e.stopPropagation();
  });

  fontFamilySelectLi.click(function () {

    var fontFamily = $(this).text();

    fontFamilySelected.text(fontFamily)

    var textDoms = $('.text')
    $(textDoms).css('font-family', fontFamily)
    $(this).parent('ul').hide();
  });

  // 切换字体大小
  var fontSizeSelected = $(".font-size-select span");
  var fontSizeSelectLi = $(".font-size-select li");

  fontSizeSelected.click(function (e) {
    $(this).next("ul").show();
    e.stopPropagation();
  });

  fontSizeSelectLi.click(function () {

    var fontSize = $(this).text();

    fontSizeSelected.text(fontSize)

    var textMainDoms = $('.text-main')
    var textSecondaryDoms = $('.text-secondary')

    $(textMainDoms).css('font-size', $(this).attr('class').split('-')[0])
    $(textSecondaryDoms).css('font-size', $(this).attr('class').split('-')[1])

    $(this).parent('ul').hide();
  });

  $(document).click(function () {
    $(".theme-color-select ul").hide();
    $(".text-color-select ul").hide();
    $(".font-family-select ul").hide();
    $(".font-size-select ul").hide();
  });


  // 上传图片
  profilePictureInput.on('change', function () {
    $('.profile-picture-show').attr('src', $(this).val())
  })
  companyLogoInput.on('change', function () {
    $('.company-logo-show').attr('src', $(this).val())
  })
  // 圖像選擇
}

// 設置圖像URL
setImgUrl()
// 初始化輸入域
initInputEvent()
